---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：1-C#コンパイラ (csc)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的な数値**：公式ドキュメントに具体的指標なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Compilers/CSharp/csc/Program.cs`
- E-02: `src/Compilers/CSharp/Portable/CommandLine/CSharpCompiler.cs`
- E-03: `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineParser.cs`
- E-04: `src/Compilers/CSharp/Portable/CommandLine/CSharpCommandLineArguments.cs`
- E-05: `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs`
- E-06: `src/Compilers/Core/MSBuildTask/Csc.cs`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cscはC#ソースコードをILにコンパイルする | E-02 (CSharpCompiler.CreateCompilation), E-07 | ○ |
| C-02 | エントリーポイントはProgram.Main | E-01 (14-27行目) | ○ |
| C-03 | BuildClient.Runを呼び出してコンパイル実行 | E-01 (37行目) | ○ |
| C-04 | ソースファイルを並列にパース可能 | E-02 (58-74行目 RoslynParallel.For使用) | ○ |
| C-05 | CSharpCompilation.Createでコンパイルオブジェクト生成 | E-02 (160-170行目) | ○ |
| C-06 | 重複ファイル指定でCS2002警告 | E-02 (109行目 WRN_FileAlreadyIncluded) | ○ |
| C-07 | MSBuildタスクとして実行可能 | E-06 (Cscクラス定義) | ○ |
| C-08 | unsafeオプションでunsafeコード許可 | E-06 (35-39行目 AllowUnsafeBlocks) | ○ |
| C-09 | langversionでバージョン指定可能 | E-02 (282-302行目 PrintLangVersions) | ○ |
| C-10 | nullableオプション対応 | E-06 (156-166行目 Nullable) | ○ |
| C-11 | CommonCompilerを継承 | E-02 (21行目 class CSharpCompiler : CommonCompiler) | ○ |
| C-12 | ResponseFileNameはcsc.rsp | E-02 (23行目 ResponseFileName = "csc.rsp") | ○ |
| C-13 | アナライザー実行機能 | E-02 (333-342行目 ResolveAnalyzersFromArguments) | ○ |
| C-14 | ソースジェネレーター対応 | E-02 (376-379行目 CSharpGeneratorDriver.Create) | ○ |
| C-15 | FileNotFoundExceptionをキャッチして終了 | E-01 (20-26行目) | ○ |
| C-16 | 終了コードはCommonCompiler.Failed | E-01 (25行目) | ○ |
| C-17 | コンパイラサーバー経由での実行サポート | E-01 (31行目 CompilerServerLogger) | ○ |
| C-18 | 並列コンパイルによる高速化が可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（応答時間、スループット等）
  - 候補：Roslynパフォーマンスベンチマーク / Microsoft公式ドキュメント / リリースノート

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認可能な機能記述
- 0: 低リスク - エントリーポイントと処理フローの記述
- 1: 中リスク - パフォーマンス関連の記述（具体的指標なし）

## 6) レビュアーチェックリスト（最小）
- [ ] Program.csのエントリーポイント構造が正確か確認
- [ ] CSharpCompiler.CreateCompilationの処理フローが正確か確認
- [ ] コマンドラインオプションの一覧が最新か確認
- [ ] エラーコード一覧が代表的なものを網羅しているか確認
- [ ] パフォーマンス要件について公式情報源から補完が必要か検討
